<?php

use Roots\Sage\Setup;
use Roots\Sage\Wrapper;

?>

<!doctype html>
<html <?php language_attributes(); ?>>
<?php get_template_part('templates/head'); ?>

<!-- style='overflow-x: hidden;' -->

<body <?php body_class(); ?>>
    <div class="content__wrapper " style='overflow-x: hidden;'>

        <!--[if IE]>
  <div class="alert alert-warning">
    <?php _e('You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.', 'sage'); ?>
  </div>
  <![endif]-->
        <?php
      do_action('get_header');
      get_template_part('templates/header');
      ?>
        <div class="wrap container-fluid" role="document">
            <div class="content row">
                <main class="main no-padding">
                    <?php include Wrapper\template_path(); ?>
                </main><!-- /.main -->
                <?php if (Setup\display_sidebar()) : ?>
                <aside class="sidebar">
                    <?php include Wrapper\sidebar_path(); ?>
                </aside><!-- /.sidebar -->
                <?php endif; ?>
            </div><!-- /.content -->
        </div><!-- /.wrap -->
        <?php
      do_action('get_footer');
      get_template_part('templates/footer');
      wp_footer();
      ?>
    </div>
    <script src="https://unpkg.com/es6-promise@4.2.4/dist/es6-promise.auto.min.js"></script>
    <script src="https://unpkg.com/@mapbox/mapbox-sdk/umd/mapbox-sdk.min.js"></script>
    <script>
    // sustentabilidad footer links
    var sustentFooterLinks = document.querySelectorAll('.footer__sustent-link')

    sustentFooterLinks.forEach(function(el, index) {
        el.addEventListener('click', function(e) {
            localStorage.setItem('sustentIndex', index)
        });
    });
    
    var nuestrasEFooterLinks = document.querySelectorAll('.footer__nuestrasE-link')

    nuestrasEFooterLinks.forEach(function(el, index) {
        el.addEventListener('click', function(e) {
            localStorage.setItem('nuestrasEIndex', index)
        });
    });
    
    var nuestrasEMenuLinks = document.querySelectorAll("li.menu__nuestrasE-link > a")
    
    var nuestrasEMenuLinksA = Array.from(nuestrasEMenuLinks)
    console.log(nuestrasEMenuLinks)
    
    nuestrasEMenuLinksA.forEach(function(el, index) {
        el.addEventListener('click', function(e) {
            localStorage.setItem('nuestrasEIndex', index - 7)
        });
    });

    
    var sustentMenuLinks = document.querySelectorAll("li.menu__sustent-link > a")
    
    var sustentMenuLinksA = Array.from(sustentMenuLinks)
    
    


    sustentMenuLinksA.forEach(function(el, index) {
        el.addEventListener('click', function(e) {
            localStorage.setItem('sustentIndex', index - 9)
        });
    });


    
    


    // map render
    mapboxgl.accessToken =
        'pk.eyJ1IjoiZGF2aWRhcm1hbmRvIiwiYSI6ImNrY2Ixdnh1YzIxMTczNW9iOWpvM2liNzIifQ.PnNDoVNY-mHai_rYS7KiDQ';
    var map = new mapboxgl.Map({
        container: 'map',
        style: 'mapbox://styles/mapbox/streets-v11',
        center: [-99.2068, 19.3046168],
        zoom: 13
    });

    var marker = new mapboxgl.Marker()
        .setLngLat([-99.2068, 19.3046168])
        .addTo(map);
    </script>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
</body>

</html>